<?php
// Lógica para determinar si la página se carga vía AJAX o directamente
$is_ajax = isset($_GET['ajax']) && $_GET['ajax'] === 'true';

// Se asume que el archivo de conexión es accesible desde el directorio superior.
// DEBES AJUSTAR ESTA RUTA A TU CONFIGURACIÓN REAL.
require_once '../config/database.php'; // Cambia esto si tu conexión está en otra parte

// Solo incluye el header si NO es una carga AJAX
if (!$is_ajax) {
    require_once '../templates/header.php';
}

// Validación de ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    // ... (Manejo de errores sin cambios) ...
    exit();
}
$id_equipo = (int)$_GET['id'];

// Consulta 1: Obtener los detalles del equipo
$sql_equipo = "SELECT e.*, s.nombre AS sucursal_nombre, t.nombre AS tipo_nombre, ma.nombre as marca_nombre, mo.nombre as modelo_nombre
               FROM equipos e
               LEFT JOIN sucursales s ON e.id_sucursal = s.id
               LEFT JOIN tipos_equipo t ON e.id_tipo_equipo = t.id
               LEFT JOIN marcas ma ON e.id_marca = ma.id
               LEFT JOIN modelos mo ON e.id_modelo = mo.id
               WHERE e.id = ?";
$stmt_equipo = $conexion->prepare($sql_equipo);
$stmt_equipo->bind_param("i", $id_equipo);
$stmt_equipo->execute();
$equipo = $stmt_equipo->get_result()->fetch_assoc();

if (!$equipo) {
    // ... (Manejo de errores sin cambios) ...
    exit();
}

// Consulta 2: Obtener el historial de reparaciones de ESE equipo
$sql_reparaciones = "SELECT * FROM reparaciones WHERE id_equipo = ? ORDER BY fecha_ingreso DESC";
$stmt_reparaciones = $conexion->prepare($sql_reparaciones);
$stmt_reparaciones->bind_param("i", $id_equipo);
$stmt_reparaciones->execute();
$historial_reparaciones = $stmt_reparaciones->get_result();
?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <?php if (!$is_ajax): ?>
        <h1 class="h2">Detalle de Equipo</h1>
        <a href="equipos.php" class="btn btn-secondary"><i class="bi bi-arrow-left me-2"></i> Volver al Listado</a>
    <?php else: ?>
        <h5 class="mb-0">Información del Equipo: <span class="text-primary"><?php echo htmlspecialchars($equipo['codigo_inventario'] ?? 'N/A'); ?></span></h5>
    <?php endif; ?>
</div>

<div class="card mb-4">
    <?php if (!$is_ajax): ?>
        <div class="card-header">
            Información General del Equipo: <?php echo htmlspecialchars($equipo['codigo_inventario'] ?? 'N/A'); ?>
        </div>
    <?php endif; ?>

    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Tipo:</strong> <?php echo htmlspecialchars($equipo['tipo_nombre'] ?? 'N/A'); ?></p>
                <p><strong>Marca / Modelo:</strong> <?php echo htmlspecialchars(($equipo['marca_nombre'] ?? 'N/A') . ' / ' . ($equipo['modelo_nombre'] ?? 'N/A')); ?></p>
                <p><strong>Número de Serie:</strong> <?php echo htmlspecialchars($equipo['numero_serie'] ?? 'N/A'); ?></p>
            </div>
            <div class="col-md-6">
                <p><strong>Fecha de Adquisición:</strong> <?php echo isset($equipo['fecha_adquisicion']) ? date('d/m/Y', strtotime($equipo['fecha_adquisicion'])) : 'N/A'; ?></p>
                <p><strong>Sucursal:</strong> <?php echo htmlspecialchars($equipo['sucursal_nombre'] ?? 'N/A'); ?></p>
                <p><strong>Estado Actual:</strong> 
                    <?php
                    $estado = htmlspecialchars($equipo['estado'] ?? 'Desconocido');
                    $clase_badge = 'bg-secondary';
                    if ($estado == 'Disponible') $clase_badge = 'bg-success';
                    if ($estado == 'Asignado') $clase_badge = 'bg-primary';
                    if ($estado == 'En Reparación') $clase_badge = 'bg-warning text-dark';
                    if ($estado == 'De Baja') $clase_badge = 'bg-danger';
                    ?>
                    <span class="badge <?php echo $clase_badge; ?>"><?php echo $estado; ?></span>
                </p>
            </div>
        </div>
        <?php if (!empty($equipo['caracteristicas'])): ?>
            <hr>
            <p><strong>Características:</strong> <?php echo nl2br(htmlspecialchars($equipo['caracteristicas'])); ?></p>
        <?php endif; ?>
        <?php if (!empty($equipo['proveedor'])): ?>
            <p><strong>Proveedor:</strong> <?php echo htmlspecialchars($equipo['proveedor']); ?></p>
        <?php endif; ?>
         <?php if (!empty($equipo['observaciones'])): ?>
            <p><strong>Observaciones:</strong> <?php echo nl2br(htmlspecialchars($equipo['observaciones'])); ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-header">
        Historial de Reparaciones
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="tabla-historial-small" class="table table-sm table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th class="all">F. Ingreso</th>
                        <th class="all">Motivo</th> 
                        
                        <th class="all">F. Salida</th> 
                        
                        <th class="all">Observaciones</th> 
                        
                        <th class="all">Costo</th> 
                        
                        <th class="all">Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($historial_reparaciones->num_rows > 0): ?>
                        <?php while ($rep = $historial_reparaciones->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo date('d/m/Y', strtotime($rep['fecha_ingreso'])); ?></td>
                                <td><?php echo htmlspecialchars($rep['motivo'] ?? '---'); ?></td>
                                <td><?php echo $rep['fecha_salida'] ? date('d/m/Y', strtotime($rep['fecha_salida'])) : '---'; ?></td>
                                
                                <td><?php echo nl2br(htmlspecialchars($rep['observaciones_salida'] ?? '---')); ?></td>
                                
                                <td class="text-success">
                                    <?php echo htmlspecialchars($_SESSION['configuracion']['moneda_simbolo'] ?? 'S/'); ?> <?php echo number_format($rep['costo'], 2); ?>
                                </td>
                                
                                <td>
                                    <span class="badge <?php echo $rep['estado_reparacion'] == 'En Proceso' ? 'bg-warning text-dark' : 'bg-secondary'; ?>">
                                        <?php echo htmlspecialchars($rep['estado_reparacion']); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php elseif (!$is_ajax): ?>
                        <tr><td colspan="6" class="text-center text-muted">Este equipo no tiene reparaciones registradas.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if ($is_ajax): ?>
<script>
$(document).ready(function() {
    // Usamos setTimeout para asegurar que DataTables se inicialice DESPUÉS 
    // de que el modal haya terminado de cargarse.
    setTimeout(function() {
        if ($.fn.DataTable.isDataTable('#tabla-historial-small')) { 
            $('#tabla-historial-small').DataTable().destroy(); 
        }

        var historialTable = $('#tabla-historial-small').DataTable({
            "language": { "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json" },
            "responsive": true, // La clave
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "info": true,
            "order": [[ 0, "desc" ]],
            "pageLength": 5,
            "dom": 'lfrtip' 
        });

        // 🎯 Solución clave: Recalcular la respuesta y ajustar las columnas 
        // una vez que la tabla se ha inicializado.
        historialTable.responsive.recalc();
        historialTable.columns.adjust();
        
    }, 10); 
    
    // 💡 Paso adicional: Disparar el ajuste cuando el modal termina de mostrarse.
    // Esto requiere que el script se ejecute DENTRO del modal o que el modal 
    // tenga un ID conocido (en este caso, #modalDetalle, que está en equipos.php)
    $('#modalDetalle').on('shown.bs.modal', function () {
        // Asumiendo que 'historialTable' es accesible o re-seleccionando
        var tabla = $('#tabla-historial-small').DataTable();
        tabla.responsive.recalc();
        tabla.columns.adjust();
    });

});

</script>

<style>
/* 🎯 Para asegurar que la fuente y el padding sean pequeños */
#tabla-historial-small th, 
#tabla-historial-small td {
    font-size: 0.85rem !important; 
    padding: 0.3rem !important; 
}
</style>
<?php endif; ?>
