<?php
require_once '../templates/header.php';

// --- Lógica para CAMBIAR ESTADO ---
if (isset($_GET['action']) && isset($_GET['id']) && isset($_GET['type'])) {
    $id = (int)$_GET['id'];
    $type = $_GET['type'];
    $action = $_GET['action'];
    $estado = ($action == 'deactivate') ? 'Inactivo' : 'Activo';
    
    // Mapa de tipos a tablas (asegúrate que 'tipo_equipo' esté correcto)
    $table_map = [
        'sucursal' => 'sucursales', 
        'tipo_equipo' => 'tipos_equipo', // Nombre de tipo esperado por catalogo_editar.php
        'marca' => 'marcas', 
        'modelo' => 'modelos', 
        'area' => 'areas', 
        'cargo' => 'cargos',
        'tipo' => 'tipos_equipo' // Dejamos esto por si la acción de activar/desactivar usa 'tipo'
    ];

    if (array_key_exists($type, $table_map)) {
        $table_name = $table_map[$type];
        $stmt = $conexion->prepare("UPDATE {$table_name} SET estado = ? WHERE id = ?");
        $stmt->bind_param("si", $estado, $id);
        $stmt->execute();
        header("Location: gestion_catalogos.php");
        exit();
    }
}

// --- Lógica para AÑADIR NUEVOS ELEMENTOS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = null;
    if (isset($_POST['catalogo'])) {
        $catalogo = $_POST['catalogo'];
        $nombre = $_POST['nombre'];
        switch ($catalogo) {
            case 'tipo': $stmt = $conexion->prepare("INSERT INTO tipos_equipo (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); break;
            case 'marca': $stmt = $conexion->prepare("INSERT INTO marcas (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); break;
            case 'area': $stmt = $conexion->prepare("INSERT INTO areas (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); break;
            case 'modelo': $id_marca = $_POST['id_marca']; $stmt = $conexion->prepare("INSERT INTO modelos (id_marca, nombre) VALUES (?, ?)"); $stmt->bind_param("is", $id_marca, $nombre); break;
            case 'cargo': $id_area = $_POST['id_area']; $stmt = $conexion->prepare("INSERT INTO cargos (id_area, nombre) VALUES (?, ?)"); $stmt->bind_param("is", $id_area, $nombre); break;
        }
    } elseif (isset($_POST['catalogo_sucursal'])) {
        $nombre = $_POST['nombre_sucursal'];
        $direccion = $_POST['direccion_sucursal'];
        $stmt = $conexion->prepare("INSERT INTO sucursales (nombre, direccion) VALUES (?, ?)");
        $stmt->bind_param("ss", $nombre, $direccion);
    }
    // --- Lógica para AÑADIR NUEVOS ELEMENTOS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = null;
    $redirect_tab = ''; // Variable para la pestaña a redirigir
    
    if (isset($_POST['catalogo'])) {
        $catalogo = $_POST['catalogo'];
        $nombre = $_POST['nombre'];
        switch ($catalogo) {
            case 'tipo': $stmt = $conexion->prepare("INSERT INTO tipos_equipo (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); $redirect_tab = 'tipos'; break;
            case 'marca': $stmt = $conexion->prepare("INSERT INTO marcas (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); $redirect_tab = 'marcas'; break;
            case 'area': $stmt = $conexion->prepare("INSERT INTO areas (nombre) VALUES (?)"); $stmt->bind_param("s", $nombre); $redirect_tab = 'areas'; break;
            case 'modelo': $id_marca = $_POST['id_marca']; $stmt = $conexion->prepare("INSERT INTO modelos (id_marca, nombre) VALUES (?, ?)"); $stmt->bind_param("is", $id_marca, $nombre); $redirect_tab = 'modelos'; break;
            case 'cargo': $id_area = $_POST['id_area']; $stmt = $conexion->prepare("INSERT INTO cargos (id_area, nombre) VALUES (?, ?)"); $stmt->bind_param("is", $id_area, $nombre); $redirect_tab = 'cargos'; break;
        }
    } elseif (isset($_POST['catalogo_sucursal'])) {
        $nombre = $_POST['nombre_sucursal'];
        $direccion = $_POST['direccion_sucursal'];
        $stmt = $conexion->prepare("INSERT INTO sucursales (nombre, direccion) VALUES (?, ?)");
        $stmt->bind_param("ss", $nombre, $direccion);
        $redirect_tab = 'sucursales';
    }
    
    if ($stmt && $stmt->execute()) { 
        // Redirigir con la pestaña y el estado de éxito
        header("Location: gestion_catalogos.php?status=success&tab={$redirect_tab}");
        exit(); 
    } elseif($stmt) { 
        // Mostrar el error directamente o redirigir con error
        echo "<div class='alert alert-danger mt-3'>Error al agregar: " . $stmt->error . "</div>"; 
    }
    if ($stmt) $stmt->close();
}
// ..
}

// --- Cargar datos existentes para las tablas ---
$sucursales = $conexion->query("SELECT * FROM sucursales ORDER BY nombre");
$tipos = $conexion->query("SELECT * FROM tipos_equipo ORDER BY nombre");
$marcas = $conexion->query("SELECT * FROM marcas ORDER BY nombre");
$modelos = $conexion->query("SELECT m.id, m.nombre, m.estado, ma.nombre as marca_nombre FROM modelos m JOIN marcas ma ON m.id_marca = ma.id ORDER BY ma.nombre, m.nombre");
$areas = $conexion->query("SELECT * FROM areas ORDER BY nombre");
$cargos = $conexion->query("SELECT c.id, c.nombre, c.estado, a.nombre AS area_nombre FROM cargos c JOIN areas a ON c.id_area = a.id ORDER BY a.nombre, c.nombre");
?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h2">Gestión de Catálogos</h1>
</div>

<ul class="nav nav-tabs mb-4" id="catalogTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="sucursales-tab" data-bs-toggle="tab" data-bs-target="#sucursales-pane" type="button" role="tab"><i class="bi bi-building me-2"></i>Sucursales</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="areas-tab" data-bs-toggle="tab" data-bs-target="#areas-pane" type="button" role="tab"><i class="bi bi-diagram-3 me-2"></i>Áreas</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="cargos-tab" data-bs-toggle="tab" data-bs-target="#cargos-pane" type="button" role="tab"><i class="bi bi-person-badge me-2"></i>Cargos</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="tipos-tab" data-bs-toggle="tab" data-bs-target="#tipos-pane" type="button" role="tab"><i class="bi bi-pc-display me-2"></i>Tipos de Equipo</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="marcas-tab" data-bs-toggle="tab" data-bs-target="#marcas-pane" type="button" role="tab"><i class="bi bi-tags me-2"></i>Marcas</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="modelos-tab" data-bs-toggle="tab" data-bs-target="#modelos-pane" type="button" role="tab"><i class="bi bi-box me-2"></i>Modelos</button>
    </li>
</ul>

<div class="tab-content" id="catalogTabsContent">
    
    <div class="tab-pane fade show active" id="sucursales-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Sucursales</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo_sucursal" value="1">
                            <div class="mb-2">
                                <label class="form-label">Nombre <span class="text-danger">*</span></label>
                                <input type="text" name="nombre_sucursal" class="form-control" required>
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Dirección</label>
                                <textarea name="direccion_sucursal" class="form-control" rows="1"></textarea>
                            </div>
                            <button class="btn btn-primary btn-sm" type="submit"><i class="bi bi-plus"></i> Agregar Sucursal</button>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php $sucursales->data_seek(0); while ($item = $sucursales->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($item['nombre']); ?></strong><br>
                                            <small class="text-muted"><?php echo htmlspecialchars($item['direccion']); ?></small>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=sucursal" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=sucursal" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=sucursal" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade" id="areas-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Áreas</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo" value="area">
                            <div class="input-group">
                                <input type="text" name="nombre" class="form-control" placeholder="Nueva área... *" required>
                                <button class="btn btn-primary" type="submit" title="Agregar Área"><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php $areas->data_seek(0); while ($item = $areas->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <?php echo htmlspecialchars($item['nombre']); ?>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=area" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=area" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=area" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-pane fade" id="cargos-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Cargos</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo" value="cargo">
                            <div class="mb-2">
                                <select name="id_area" class="form-select" required>
                                    <option value="">Selecciona un área *</option>
                                    <?php $areas->data_seek(0); while($area = $areas->fetch_assoc()): ?>
                                        <option value="<?php echo $area['id']; ?>"><?php echo htmlspecialchars($area['nombre']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <input type="text" name="nombre" class="form-control" placeholder="Nuevo cargo... *" required>
                                <button class="btn btn-primary" type="submit" title="Agregar Cargo"><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php while ($item = $cargos->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($item['area_nombre']); ?></strong> - <?php echo htmlspecialchars($item['nombre']); ?>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=cargo" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=cargo" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=cargo" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade" id="tipos-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Tipos de Equipo</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo" value="tipo">
                            <div class="input-group">
                                <input type="text" name="nombre" class="form-control" placeholder="Nuevo tipo... *" required>
                                <button class="btn btn-primary" type="submit" title="Agregar Tipo"><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php while($item = $tipos->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <?php echo htmlspecialchars($item['nombre']); ?>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=tipo_equipo" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=tipo" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=tipo" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-pane fade" id="marcas-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Marcas</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo" value="marca">
                            <div class="input-group">
                                <input type="text" name="nombre" class="form-control" placeholder="Nueva marca... *" required>
                                <button class="btn btn-primary" type="submit" title="Agregar Marca"><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php $marcas->data_seek(0); while($item = $marcas->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <?php echo htmlspecialchars($item['nombre']); ?>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=marca" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=marca" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=marca" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-pane fade" id="modelos-pane" role="tabpanel" tabindex="0">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100">
                    <div class="card-header">Gestión de Modelos</div>
                    <div class="card-body d-flex flex-column">
                        <form method="POST" class="mb-3">
                            <input type="hidden" name="catalogo" value="modelo">
                            <div class="mb-2">
                                <select name="id_marca" class="form-select" required>
                                    <option value="">Selecciona una marca *</option>
                                    <?php $marcas->data_seek(0); while($marca = $marcas->fetch_assoc()): ?>
                                        <option value="<?php echo $marca['id']; ?>"><?php echo htmlspecialchars($marca['nombre']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <input type="text" name="nombre" class="form-control" placeholder="Nuevo modelo... *" required>
                                <button class="btn btn-primary" type="submit" title="Agregar Modelo"><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                        <hr>
                        <div class="table-responsive flex-grow-1">
                            <table class="table table-sm table-hover">
                                <tbody>
                                    <?php while($item = $modelos->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($item['marca_nombre']); ?></strong> - <?php echo htmlspecialchars($item['nombre']); ?>
                                            <span class="badge float-end <?php echo $item['estado'] == 'Activo' ? 'bg-success' : 'bg-danger'; ?>"><?php echo $item['estado']; ?></span>
                                        </td>
                                        <td class="text-end align-middle">
                                            <div class="btn-group">
                                                <a href="catalogo_editar.php?id=<?php echo $item['id']; ?>&type=modelo" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil"></i></a>
                                                <?php if ($item['estado'] == 'Activo'): ?>
                                                    <a href="?action=deactivate&id=<?php echo $item['id']; ?>&type=modelo" class="btn btn-danger btn-sm" title="Desactivar"><i class="bi bi-trash"></i></a>
                                                <?php else: ?>
                                                    <a href="?action=activate&id=<?php echo $item['id']; ?>&type=modelo" class="btn btn-success btn-sm" title="Activar"><i class="bi bi-check-circle"></i></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // 1. Manejo de Pestañas (Activación al cargar la página)
    const urlParams = new URLSearchParams(window.location.search);
    const tabName = urlParams.get('tab');
    
    if (tabName) {
        // Selecciona el botón de la pestaña usando el ID (ej: sucursales-tab)
        const tabButton = document.getElementById(tabName + '-tab');
        if (tabButton) {
            // Usa el constructor Tab de Bootstrap para mostrar la pestaña
            const bsTab = new bootstrap.Tab(tabButton);
            bsTab.show();
        }
    }

    // 2. Manejo de Alerta de Éxito (Limpiar formulario visualmente)
    const status = urlParams.get('status');
    if (status === 'success') {
        // En un caso real, la alerta estaría definida por PHP si status=success
        // Si la alerta la maneja PHP, solo necesitamos limpiar el formulario.
        
        // Identificamos el contenedor de la pestaña activa
        const activePane = document.querySelector('.tab-pane.show.active');
        
        if (activePane) {
            // Buscamos el primer formulario dentro del panel activo y lo reseteamos
            const form = activePane.querySelector('form');
            if (form) {
                form.reset();
            }
        }
        
        // OPCIONAL: Limpiar la URL después de un breve tiempo para que la pestaña activa se mantenga si recarga
        setTimeout(() => {
            const cleanUrl = window.location.pathname;
            window.history.replaceState(null, null, cleanUrl);
        }, 3000);
    }
});
</script>

<?php require_once '../templates/footer.php'; ?>