<?php
// Este archivo procesa la asignación/cambio de técnico vía AJAX

// Asegúrate de que esta ruta sea correcta para acceder a tu archivo de conexión.
require_once '../config/database.php';

// Establecer cabeceras para respuesta JSON
header('Content-Type: application/json');

// 1. Validar la solicitud POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Método No Permitido
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit();
}

$id_reparacion = filter_input(INPUT_POST, 'id_reparacion', FILTER_VALIDATE_INT);
$id_tecnico_nuevo = filter_input(INPUT_POST, 'id_tecnico_nuevo', FILTER_VALIDATE_INT);

// 2. Validar datos
if (!$id_reparacion) {
    http_response_code(400); // Solicitud Incorrecta
    echo json_encode(['success' => false, 'message' => 'ID de reparación no válido.']);
    exit();
}

// Si el id_tecnico_nuevo es 0 o nulo, lo establecemos como NULL en la DB.
// Esto permite desasignar un técnico si la opción es la primera (vacía)
$id_tecnico_db = ($id_tecnico_nuevo > 0) ? $id_tecnico_nuevo : null;

// 3. Ejecutar la actualización
try {
    $sql = "UPDATE reparaciones SET id_tecnico = ? WHERE id = ?";
    $stmt = $conexion->prepare($sql);
    
    if ($id_tecnico_db !== null) {
        // Asignar un ID de técnico válido (integer)
        $stmt->bind_param("ii", $id_tecnico_db, $id_reparacion);
    } else {
        // Asignar NULL (desasignar)
        // En MySQLi, para enlazar un valor NULL, se usa el tipo 's' con valor NULL literal
        $null = NULL;
        $stmt->bind_param("si", $null, $id_reparacion);
    }
    
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            // Éxito: Se modificó la fila
            echo json_encode(['success' => true, 'message' => 'Técnico asignado/cambiado correctamente.']);
        } else {
            // Advertencia: No se modificó la fila (ej. ya tenía ese técnico)
            echo json_encode(['success' => false, 'message' => 'No se realizaron cambios (mismo técnico asignado o reparación no encontrada).']);
        }
    } else {
        throw new Exception($stmt->error);
    }
    
    $stmt->close();
} catch (Exception $e) {
    // Error de Base de Datos
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el técnico: ' . $e->getMessage()]);
}

$conexion->close();
?>