<?php
// Asegurar que la sesión esté activa para obtener el ID del usuario
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Asegurar que el archivo de conexión a la base de datos se incluya
// AJUSTA LA RUTA SI ES NECESARIO
require_once '../config/database.php'; 

// Configurar la cabecera para devolver una respuesta JSON
header('Content-Type: application/json');

// ----------------------------------------------------
// 1. Obtener y validar datos de entrada
// ----------------------------------------------------

$id_reparacion = filter_input(INPUT_POST, 'id_reparacion', FILTER_VALIDATE_INT);
$comentario = trim($_POST['comentario'] ?? '');
// Obtener el ID del usuario logueado. Usar '1' o '0' si la sesión no está definida
$id_usuario = $_SESSION['user_id'] ?? 1; 

if (empty($id_reparacion) || $id_reparacion === false) {
    echo json_encode(['status' => 'error', 'message' => 'ID de reparación no válido.']);
    exit;
}

if (empty($comentario)) {
    echo json_encode(['status' => 'error', 'message' => 'El comentario no puede estar vacío.']);
    exit;
}

// ----------------------------------------------------
// 2. Insertar el comentario
// ----------------------------------------------------

$sql = "INSERT INTO reparacion_comentarios (id_reparacion, id_usuario, comentario) VALUES (?, ?, ?)";
$stmt = $conexion->prepare($sql);

if ($stmt === false) {
    // Error en la preparación de la consulta (ej. nombre de tabla o columna incorrecta)
    echo json_encode(['status' => 'error', 'message' => 'Error al preparar la consulta: ' . $conexion->error]);
    exit;
}

$stmt->bind_param("iis", $id_reparacion, $id_usuario, $comentario);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Comentario agregado con éxito.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error al guardar el comentario: ' . $stmt->error]);
}

$stmt->close();
$conexion->close();
?>