<?php
// Este archivo NO DEBE incluir el header/footer ya que se carga dentro de un modal

// 1. INCLUIR LA CONEXIÓN (AJUSTA LA RUTA)
// Asegúrate de que esta ruta sea correcta para acceder a tu archivo de conexión.
require_once '../config/database.php'; 

// 2. INICIAR SESIÓN (Necesario para obtener el ID de usuario para los comentarios)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_GET['id_reparacion']) || !is_numeric($_GET['id_reparacion'])) {
    die('<div class="alert alert-danger">ID de reparación no válido.</div>');
}

$id_reparacion = (int)$_GET['id_reparacion'];

// 1. Obtener detalles de la reparación, equipo y AHORA el nombre del Técnico
$sql_detalle = "SELECT r.*, e.codigo_inventario, e.numero_serie, e.caracteristicas,
                       s.nombre AS sucursal_nombre, 
                       t.nombre AS tipo_nombre, 
                       ma.nombre AS marca_nombre, 
                       mo.nombre AS modelo_nombre,
                       te.nombre AS tecnico_nombre,      /* <-- CORREGIDO: Usando 'tecnicos' */
                       te.apellido AS tecnico_apellido    /* <-- CORREGIDO: Usando 'tecnicos' */
                FROM reparaciones r
                JOIN equipos e ON r.id_equipo = e.id
                LEFT JOIN sucursales s ON e.id_sucursal = s.id
                LEFT JOIN tipos_equipo t ON e.id_tipo_equipo = t.id
                LEFT JOIN marcas ma ON e.id_marca = ma.id
                LEFT JOIN modelos mo ON e.id_modelo = mo.id
                LEFT JOIN tecnicos te ON r.id_tecnico = te.id /* <-- CORREGIDO: Unión a tabla 'tecnicos' */
                WHERE r.id = ?"; 

$stmt_detalle = $conexion->prepare($sql_detalle);
if ($stmt_detalle === false) {
    // Error si la consulta sigue fallando (ej. si la columna 'id_tecnico' aún no existe en 'reparaciones')
    die('<div class="alert alert-danger">Error al preparar la consulta de detalle. Asegúrese de haber creado la tabla `tecnicos` y la columna `id_tecnico` en `reparaciones`.</div>');
}
$stmt_detalle->bind_param("i", $id_reparacion);
$stmt_detalle->execute();
$detalle = $stmt_detalle->get_result()->fetch_assoc();
$stmt_detalle->close();

if (!$detalle) {
    die('<div class="alert alert-warning">Reparación no encontrada.</div>');
}

// OBTENER LISTA DE POSIBLES TÉCNICOS desde la NUEVA tabla `tecnicos`
$sql_tecnicos = "SELECT id, nombre, apellido FROM tecnicos WHERE estado = 'Activo' ORDER BY nombre";
$tecnicos = $conexion->query($sql_tecnicos);


// Lógica para determinar la clase del badge de prioridad
$clase_badge = '';
if ($detalle['prioridad'] == 'Alta') {
    $clase_badge = 'bg-danger';
} elseif ($detalle['prioridad'] == 'Media') {
    $clase_badge = 'bg-warning text-dark';
} else {
    $clase_badge = 'bg-info text-dark'; // Baja
}

// 2. Obtener comentarios/trabajos realizados (Línea de Tiempo)
$sql_timeline = "SELECT rc.*, u.nombre AS usuario_nombre 
                 FROM reparacion_comentarios rc 
                 LEFT JOIN usuarios u ON rc.id_usuario = u.id 
                 WHERE rc.id_reparacion = ? 
                 ORDER BY rc.fecha_comentario DESC";
$stmt_timeline = $conexion->prepare($sql_timeline);
if ($stmt_timeline === false) {
    die('<div class="alert alert-danger">Error al preparar la consulta de historial (Verifique la tabla `reparacion_comentarios` y `usuarios`).</div>');
}
$stmt_timeline->bind_param("i", $id_reparacion);
$stmt_timeline->execute();
$comentarios = $stmt_timeline->get_result();
$stmt_timeline->close();
?>

<div class="row">
    <div class="col-md-6">
        <h6><i class="bi bi-laptop me-1"></i> **Datos del Equipo**</h6>
        <p class="mb-1"><small>Código: <strong><?php echo htmlspecialchars($detalle['codigo_inventario']); ?></strong></small></p>
        <p class="mb-1"><small>N/S: <strong><?php echo htmlspecialchars($detalle['numero_serie']); ?></strong></small></p>
        <p class="mb-1"><small>Marca/Modelo: <strong><?php echo htmlspecialchars($detalle['marca_nombre'] . ' / ' . $detalle['modelo_nombre']); ?></strong></small></p>
        
        <p class="mb-1"><small>Sucursal: <strong><?php echo htmlspecialchars($detalle['sucursal_nombre'] ?? 'N/A'); ?></strong></small></p>
    </div>
    <div class="col-md-6">
        <h6><i class="bi bi-tools me-1"></i> **Detalle de Reparación**</h6>
        <p class="mb-1"><small>Motivo: <strong><?php echo htmlspecialchars($detalle['motivo']); ?></strong></small></p>
        <p class="mb-1"><small>Proveedor: <strong><?php echo htmlspecialchars($detalle['proveedor_servicio'] ?: 'No especificado'); ?></strong></small></p>
        <p class="mb-1"><small>Ingreso: <strong><?php echo date('d/m/Y', strtotime($detalle['fecha_ingreso'])); ?></strong></small></p>
        <p class="mb-1"><small>Salida: <strong><?php echo $detalle['fecha_salida'] ? date('d/m/Y', strtotime($detalle['fecha_salida'])) : 'Pendiente'; ?></strong></small></p>
        <p class="mb-1"><small>Prioridad: <span class="badge <?php echo $clase_badge; ?>"><?php echo htmlspecialchars($detalle['prioridad']); ?></span></small></p>
        <p class="mb-1"><small>Estado: <span class="badge <?php echo $detalle['estado_reparacion'] == 'En Proceso' ? 'bg-warning text-dark' : 'bg-secondary'; ?>"><?php echo htmlspecialchars($detalle['estado_reparacion']); ?></span></small></p>
    </div>
</div>

<?php if ($detalle['estado_reparacion'] == 'En Proceso'): ?>

<hr>
<div id="statusMessage" class="alert d-none"></div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <h6><i class="bi bi-person-gear me-1"></i> **Técnico Asignado**</h6>
        <form id="formCambiarTecnico" data-id="<?php echo $id_reparacion; ?>" class="d-flex gap-2 align-items-center">
            <input type="hidden" name="id_reparacion" value="<?php echo $id_reparacion; ?>">
            <select class="form-select form-select-sm w-auto" id="id_tecnico_nuevo" name="id_tecnico_nuevo" required>
                <option value="">-- Seleccionar Técnico --</option>
                <?php 
                // Asegúrate de que $tecnicos haya sido cargado correctamente antes de este punto
                // En el código anterior, obtuvimos $tecnicos de la tabla `tecnicos`.
                if ($tecnicos && $tecnicos->num_rows > 0) {
                    $tecnicos->data_seek(0);
                    while($tecnico = $tecnicos->fetch_assoc()): 
                        $nombre_completo = htmlspecialchars($tecnico['nombre'] . ' ' . $tecnico['apellido']);
                ?>
                    <option value="<?php echo $tecnico['id']; ?>" 
                            <?php if($tecnico['id'] == ($detalle['id_tecnico'] ?? null)) echo 'selected'; ?>>
                        <?php echo $nombre_completo; ?>
                    </option>
                <?php 
                    endwhile; 
                } 
                ?>
            </select>
            <button type="submit" class="btn btn-sm btn-outline-primary">Asignar / Cambiar</button>
        </form>
    </div>

    <div class="col-md-6">
        <h6><i class="bi bi-exclamation-triangle-fill me-1 text-warning"></i> **Cambiar Prioridad**</h6>
        <form id="formCambiarPrioridad" data-id="<?php echo $id_reparacion; ?>" class="d-flex gap-2 align-items-center">
            <input type="hidden" name="id_reparacion" value="<?php echo $id_reparacion; ?>">
            <select class="form-select form-select-sm w-auto" id="nueva_prioridad" name="nueva_prioridad" required>
                <option value="Baja" <?php if($detalle['prioridad'] == 'Baja') echo 'selected'; ?>>Baja</option>
                <option value="Media" <?php if($detalle['prioridad'] == 'Media') echo 'selected'; ?>>Media</option>
                <option value="Alta" <?php if($detalle['prioridad'] == 'Alta') echo 'selected'; ?>>Alta</option>
            </select>
            <button type="submit" class="btn btn-sm btn-outline-warning">Actualizar Prioridad</button>
        </form>
    </div>
</div>
    
</form>


<hr>

<?php endif; ?>

<h6><i class="bi bi-chat-text-fill me-1"></i> **Agregar Comentario / Trabajo Realizado**</h6>
<form id="formComentarioReparacion" data-id="<?php echo $id_reparacion; ?>" class="mb-4">
    <input type="hidden" name="id_reparacion" value="<?php echo $id_reparacion; ?>">
    <input type="hidden" name="id_usuario" value="<?php echo $_SESSION['user_id'] ?? 0; ?>"> 
    <div class="input-group">
        <textarea name="comentario" class="form-control form-control-sm" placeholder="Detalle el trabajo realizado..." rows="1" required></textarea>
        <button type="submit" class="btn btn-sm btn-primary" <?php echo $detalle['estado_reparacion'] !== 'En Proceso' ? 'disabled' : ''; ?>>Comentar</button>
    </div>
    <?php if ($detalle['estado_reparacion'] !== 'En Proceso'): ?>
        <small class="text-muted">No se pueden agregar comentarios a reparaciones finalizadas o canceladas.</small>
    <?php endif; ?>
</form>

<h6><i class="bi bi-clock-history me-1"></i> **Historial de Trabajos**</h6>
<div class="timeline" style="max-height: 300px; overflow-y: auto;">
    <?php if ($comentarios && $comentarios->num_rows > 0): ?>
        <?php while ($comentario = $comentarios->fetch_assoc()): ?>
            <div class="timeline-item mb-2 p-2 border-start border-3 border-secondary" style="margin-left: 10px;">
                <p class="mb-0 small">
                    <?php echo nl2br(htmlspecialchars($comentario['comentario'])); ?>
                </p>
                <small class="text-muted fst-italic">
                    <?php echo htmlspecialchars($comentario['usuario_nombre'] ?? 'Usuario Desconocido'); ?> - <?php echo date('d/m/Y H:i', strtotime($comentario['fecha_comentario'])); ?>
                </small>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p class="text-muted small">Aún no hay trabajos o comentarios registrados.</p>
    <?php endif; ?>
</div>

<script>
// Función para mostrar mensajes de estado (Necesaria para los mensajes de éxito/error)
function showStatusMessage(message, type = 'success') {
    const statusDiv = $('#statusMessage');
    // Asegurarse de que el div de mensaje exista, si no, lo crea (asumiendo que está definido en el HTML previo)
    if (!statusDiv.length) {
        console.error("El elemento #statusMessage no se encontró.");
        return;
    }
    
    statusDiv.removeClass('d-none alert-success alert-danger alert-warning');
    statusDiv.addClass('alert-' + type);
    statusDiv.text(message);
    
    // Ocultar el mensaje después de 4 segundos
    setTimeout(() => {
        statusDiv.addClass('d-none');
        statusDiv.text('');
    }, 4000);
}

// 1. Lógica para agregar comentario (existente)
$('#formComentarioReparacion').on('submit', function(e) {
    e.preventDefault();
    const form = $(this);
    const idReparacion = form.data('id');
    
    $.post('reparacion_comentario_add.php', form.serialize())
        .done(function(response) {
            form.find('textarea[name="comentario"]').val('');
            const urlDetalle = 'reparacion_detalle.php?id_reparacion=' + idReparacion;
            
            $('#contenidoDetalleReparacion').load(urlDetalle, function() {
                 showStatusMessage('Comentario agregado correctamente.', 'success');
            });
        })
        .fail(function(xhr) {
            showStatusMessage('Error al guardar el comentario. Consulte la consola.', 'danger');
            console.error(xhr.responseText);
        });
});


// 2. Lógica para cambiar prioridad (CORREGIDA)
$('#formCambiarPrioridad').on('submit', function(e) {
    e.preventDefault(); // <-- CLAVE: Previene el envío normal del formulario (que cerraría el modal)
    const form = $(this);
    const idReparacion = form.data('id');

    // Importante: Indicamos que esperamos una respuesta JSON ('json')
    $.post('reparacion_actualizar_prioridad.php', form.serialize(), null, 'json') 
        .done(function(response) {
            if (response.success) {
                // Recargar el detalle para mostrar la nueva prioridad en la vista
                const urlDetalle = 'reparacion_detalle.php?id_reparacion=' + idReparacion;
                
                // Recarga el contenido del modal y luego muestra el mensaje de éxito
                $('#contenidoDetalleReparacion').load(urlDetalle, function() {
                    // Usamos la nueva prioridad del JSON para el mensaje
                    const nuevaPrioridad = response.nueva_prioridad || form.find('#nueva_prioridad').val();
                    showStatusMessage('Prioridad actualizada a ' + nuevaPrioridad + '.', 'success');
                });
            } else {
                 showStatusMessage(response.message || 'No se pudo actualizar la prioridad.', 'warning');
            }
        })
        .fail(function(xhr) {
            // Manejo de errores de conexión o errores fatales en PHP
            try {
                const errorResponse = JSON.parse(xhr.responseText);
                showStatusMessage('Error de servidor: ' + errorResponse.message, 'danger');
            } catch (e) {
                showStatusMessage('Error de conexión o error fatal en el servidor al cambiar prioridad.', 'danger');
            }
            console.error('Error AJAX al cambiar prioridad:', xhr.responseText);
        });
});

// 3. Lógica para cambiar Técnico (REVISADA)
$('#formCambiarTecnico').on('submit', function(e) {
    e.preventDefault();
    const form = $(this);
    const idReparacion = form.data('id');
    
    $.post('reparacion_actualizar_tecnico.php', form.serialize(), null, 'json')
        .done(function(response) {
            if (response.success) {
                const urlDetalle = 'reparacion_detalle.php?id_reparacion=' + idReparacion;
                $('#contenidoDetalleReparacion').load(urlDetalle, function() {
                    showStatusMessage(response.message, 'success');
                });
            } else {
                showStatusMessage(response.message || 'Error desconocido al asignar el técnico.', 'warning');
            }
        })
        .fail(function(xhr) {
            try {
                const errorResponse = JSON.parse(xhr.responseText);
                showStatusMessage('Error de servidor: ' + errorResponse.message, 'danger');
            } catch (e) {
                showStatusMessage('Error de conexión al asignar el técnico. Revise los logs.', 'danger');
            }
            console.error('Error AJAX al cambiar técnico:', xhr.responseText);
        });
});
</script>