<?php
// Este archivo actúa como un endpoint de AJAX, no debe incluir header/footer.
// No necesitamos iniciar sesión ya que es para el público.

// 1. INCLUIR LA CONEXIÓN (AJUSTA LA RUTA)
// Asegúrate de que esta ruta sea correcta para acceder a tu archivo de conexión.
require_once '../config/database.php'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['codigo_inventario'])) {
    die('<div class="alert alert-warning">Acceso denegado o código no proporcionado.</div>');
}

$codigo_inventario = trim($_POST['codigo_inventario']);

if (empty($codigo_inventario)) {
    die('<div class="alert alert-warning">El código de inventario no puede estar vacío.</div>');
}

// ----------------------------------------------------
// 1. Encontrar la ÚLTIMA reparación para el código de inventario
// ----------------------------------------------------

$sql_reparacion = "
    SELECT r.id AS id_reparacion, r.fecha_ingreso, r.fecha_salida, r.motivo, r.proveedor_servicio, r.estado_reparacion, 
           e.codigo_inventario, e.numero_serie, e.caracteristicas,
           s.nombre AS sucursal_nombre, 
           t.nombre AS tipo_nombre, 
           ma.nombre AS marca_nombre, 
           mo.nombre AS modelo_nombre
    FROM reparaciones r
    JOIN equipos e ON r.id_equipo = e.id
    LEFT JOIN sucursales s ON e.id_sucursal = s.id
    LEFT JOIN tipos_equipo t ON e.id_tipo_equipo = t.id
    LEFT JOIN marcas ma ON e.id_marca = ma.id
    LEFT JOIN modelos mo ON e.id_modelo = mo.id
    WHERE e.codigo_inventario = ? 
    ORDER BY r.fecha_ingreso DESC, r.id DESC
    LIMIT 1"; // Buscamos la reparación más reciente para ese equipo

$stmt_reparacion = $conexion->prepare($sql_reparacion);
if ($stmt_reparacion === false) {
    die('<div class="alert alert-danger">Error al preparar la consulta de detalle. Verifique los nombres de las tablas.</div>');
}
$stmt_reparacion->bind_param("s", $codigo_inventario);
$stmt_reparacion->execute();
$detalle = $stmt_reparacion->get_result()->fetch_assoc();
$stmt_reparacion->close();

if (!$detalle) {
    die('<div class="alert alert-danger">No se encontró ninguna reparación registrada para el código de inventario: <strong>' . htmlspecialchars($codigo_inventario) . '</strong>.</div>');
}

$id_reparacion = $detalle['id_reparacion'];

// ----------------------------------------------------
// 2. Obtener comentarios/trabajos realizados (Línea de Tiempo)
// ----------------------------------------------------

$sql_timeline = "SELECT rc.*, u.nombre AS usuario_nombre 
                 FROM reparacion_comentarios rc 
                 -- No es crítico que el nombre de usuario aparezca en la web pública,
                 -- pero si quieres ocultarlo, puedes omitir el JOIN y solo mostrar la fecha.
                 LEFT JOIN usuarios u ON rc.id_usuario = u.id 
                 WHERE rc.id_reparacion = ? 
                 ORDER BY rc.fecha_comentario DESC";

$stmt_timeline = $conexion->prepare($sql_timeline);
if ($stmt_timeline === false) {
    // Si la tabla reparacion_comentarios no existe, fallará aquí.
    // Esto es más seguro que un Error 500.
    die('<div class="alert alert-danger">Error interno al buscar el historial. Consulte con soporte.</div>');
}
$stmt_timeline->bind_param("i", $id_reparacion);
$stmt_timeline->execute();
$comentarios = $stmt_timeline->get_result();
$stmt_timeline->close();
?>

<div class="card shadow-lg border-0">
    <div class="card-header bg-primary text-white">
        <h4 class="mb-0">Estado de Reparación - Código: <?php echo htmlspecialchars($detalle['codigo_inventario']); ?></h4>
    </div>
    <div class="card-body">
        
        <h5 class="mb-3">
            Estado Actual: 
            <span class="badge fs-5 <?php echo $detalle['estado_reparacion'] == 'En Proceso' ? 'bg-warning text-dark' : 'bg-success'; ?>">
                <?php echo htmlspecialchars($detalle['estado_reparacion']); ?>
            </span>
        </h5>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <h6><i class="bi bi-laptop me-1"></i> **Datos del Equipo**</h6>
                <p class="mb-1"><strong>N/S:</strong> <?php echo htmlspecialchars($detalle['numero_serie']); ?></p>
                <p class="mb-1"><strong>Tipo:</strong> <?php echo htmlspecialchars($detalle['tipo_nombre'] ?? 'N/A'); ?></p>
                <p class="mb-1"><strong>Marca/Modelo:</strong> <?php echo htmlspecialchars($detalle['marca_nombre'] . ' / ' . $detalle['modelo_nombre']); ?></p>
                <p class="mb-1"><strong>Descripcion:</strong> <?php echo htmlspecialchars($detalle['caracteristicas'] ??'N/A'); ?></p>
                <p class="mb-1"><strong>Ubicación:</strong> <?php echo htmlspecialchars($detalle['sucursal_nombre'] ?? 'N/A'); ?></p>
            </div>
            <div class="col-md-6">
                <h6><i class="bi bi-tools me-1"></i> **Detalle de Reparación**</h6>
                <p class="mb-1"><strong>Motivo Inicial:</strong> <?php echo htmlspecialchars($detalle['motivo']); ?></p>
                <p class="mb-1"><strong>Proveedor:</strong> <?php echo htmlspecialchars($detalle['proveedor_servicio'] ?: 'No especificado'); ?></p>
                <p class="mb-1"><strong>Fecha Ingreso:</strong> <?php echo date('d/m/Y', strtotime($detalle['fecha_ingreso'])); ?></p>
                <p class="mb-1"><strong>Fecha Salida:</strong> <?php echo $detalle['fecha_salida'] ? date('d/m/Y', strtotime($detalle['fecha_salida'])) : '---'; ?></p>
            </div>
        </div>

        <hr>

        <h6><i class="bi bi-clock-history me-1"></i> **Historial de Trabajos y Actualizaciones**</h6>
        <div class="timeline" style="max-height: 300px; overflow-y: auto;">
            <?php if ($comentarios && $comentarios->num_rows > 0): ?>
                <?php while ($comentario = $comentarios->fetch_assoc()): ?>
                    <div class="timeline-item mb-3 p-3 border-start border-4 border-info bg-light">
                        <p class="mb-1 small">
                            <?php echo nl2br(htmlspecialchars($comentario['comentario'])); ?>
                        </p>
                        <small class="text-muted fst-italic d-block">
                            Actualizado el <?php echo date('d/m/Y', strtotime($comentario['fecha_comentario'])); ?> a las <?php echo date('H:i', strtotime($comentario['fecha_comentario'])); ?>
                            <?php if (!empty($comentario['usuario_nombre'])): ?>
                                (por <?php echo htmlspecialchars($comentario['usuario_nombre']); ?>)
                            <?php endif; ?>
                        </small>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="alert alert-info small">Aún no se han registrado trabajos o comentarios adicionales.</div>
            <?php endif; ?>
        </div>

    </div>
</div>