<?php
require_once '../templates/header.php';

// Lógica del filtro de estado
$filtro_estado = $_GET['estado'] ?? 'En Proceso'; // Por defecto muestra 'En Proceso'

$sql = "SELECT r.id AS id_reparacion, r.fecha_ingreso, r.fecha_salida, r.motivo, r.proveedor_servicio, r.estado_reparacion, r.prioridad,
            e.codigo_inventario, ma.nombre as marca_nombre, mo.nombre as modelo_nombre
        FROM reparaciones r
        JOIN equipos e ON r.id_equipo = e.id
        LEFT JOIN marcas ma ON e.id_marca = ma.id
        LEFT JOIN modelos mo ON e.id_modelo = mo.id";

if ($filtro_estado !== 'Todas') {
    $sql .= " WHERE r.estado_reparacion = ?";
}
$sql .= " ORDER BY r.fecha_ingreso DESC";

$stmt = $conexion->prepare($sql);
if ($filtro_estado !== 'Todas') {
    $stmt->bind_param("s", $filtro_estado);
}
$stmt->execute();
$resultado = $stmt->get_result();
?>

<h1 class="h2 mb-4">Historial de Reparaciones</h1>

<div class="card mb-4">
    <div class="card-body">
        <form action="reparaciones.php" method="GET" class="d-flex align-items-center">
            <label for="estado" class="form-label me-2 mb-0">Filtrar por estado:</label>
            <select name="estado" id="estado" class="form-select w-auto" onchange="this.form.submit()">
                <option value="En Proceso" <?php if($filtro_estado == 'En Proceso') echo 'selected'; ?>>En Proceso</option>
                <option value="Finalizada" <?php if($filtro_estado == 'Finalizada') echo 'selected'; ?>>Finalizada</option>
                <option value="Todas" <?php if($filtro_estado == 'Todas') echo 'selected'; ?>>Todas</option>
            </select>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        Listado de Reparaciones
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Código Equipo</th>
                        <th>Marca / Modelo</th>
                        <th>Fecha Ingreso</th>
                        <th>Fecha Salida</th>
                        <th>Motivo</th>
                        <th>Prioridad</th> <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultado && $resultado->num_rows > 0): ?>
                        <?php while ($reparacion = $resultado->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($reparacion['codigo_inventario']); ?></td>
                                <td><?php echo htmlspecialchars($reparacion['marca_nombre'] . ' / ' . $reparacion['modelo_nombre']); ?></td>
                                <td><?php echo date('d/m/Y', strtotime($reparacion['fecha_ingreso'])); ?></td>
                                <td><?php echo $reparacion['fecha_salida'] ? date('d/m/Y', strtotime($reparacion['fecha_salida'])) : '---'; ?></td>
                                <td><?php echo htmlspecialchars($reparacion['motivo']); ?></td>
                                
                                <td>
                                    <?php 
                                        $clase_badge = '';
                                        if ($reparacion['prioridad'] == 'Alta') {
                                            $clase_badge = 'bg-danger';
                                        } elseif ($reparacion['prioridad'] == 'Media') {
                                            $clase_badge = 'bg-warning text-dark';
                                        } else {
                                            $clase_badge = 'bg-info text-dark'; // Baja
                                        }
                                    ?>
                                    <span class="badge <?php echo $clase_badge; ?>">
                                        <?php echo htmlspecialchars($reparacion['prioridad']); ?>
                                    </span>
                                </td>
                                
                                <td>
                                    <span class="badge <?php echo $reparacion['estado_reparacion'] == 'En Proceso' ? 'bg-warning text-dark' : 'bg-secondary'; ?>">
                                        <?php echo htmlspecialchars($reparacion['estado_reparacion']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Acciones de Reparación">
                                        <a href="reparacion_detalle.php" 
                                        class="btn btn-primary btn-sm ver-detalle-reparacion" 
                                        data-id="<?php echo $reparacion['id_reparacion']; ?>" 
                                        title="Ver Detalle de Reparación"
                                        data-bs-toggle="modal" 
                                        data-bs-target="#modalDetalleReparacion">
                                            <i class="bi bi-eye-fill"></i>
                                        </a>

                                        <?php if ($reparacion['estado_reparacion'] == 'En Proceso'): ?>
                                            <a href="reparacion_finalizar.php?id_reparacion=<?php echo $reparacion['id_reparacion']; ?>" 
                                            class="btn btn-success btn-sm" 
                                            title="Finalizar Reparación">
                                                <i class="bi bi-check-circle-fill"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="8" class="text-center">No hay reparaciones que coincidan con el filtro.</td></tr> <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalDetalleReparacion" tabindex="-1" aria-labelledby="modalDetalleReparacionLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalDetalleReparacionLabel">Detalle de Reparación y Tiempos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="contenidoDetalleReparacion">Cargando...</div>
      </div>
    </div>
  </div>
</div>



<?php require_once '../templates/footer.php'; ?>

<script>
// Asegúrate de que jQuery esté cargado (es necesario si usas DataTables o Boostrap con frecuencia)
$(document).ready(function() {
    // --- LÓGICA DEL MODAL DE DETALLE DE REPARACIÓN ---
    $('.ver-detalle-reparacion').on('click', function(e) {
        e.preventDefault(); 
        var reparacionId = $(this).data('id');
        // Usamos un nuevo archivo 'reparacion_detalle.php' para el contenido del modal
        var urlDetalle = 'reparacion_detalle.php?id_reparacion=' + reparacionId;
        
        // Muestra el mensaje de carga
        $('#contenidoDetalleReparacion').html('<div class="text-center py-5">Cargando...</div>');
        
        // Carga el contenido del archivo PHP vía AJAX
        $('#contenidoDetalleReparacion').load(urlDetalle, function(response, status, xhr) {
            if (status == "error") {
                $('#contenidoDetalleReparacion').html('<div class="alert alert-danger">Error al cargar el detalle de la reparación: ' + xhr.status + ' ' + xhr.statusText + '</div>');
            }
        });
    });
    // --- FIN LÓGICA DEL MODAL DE DETALLE DE REPARACIÓN ---
});


</script>