<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seguimiento de Reparación de Equipos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>
<body class="bg-light">
    <div class="container py-5">
        <header class="text-center mb-5">
            <h1 class="display-6">Seguimiento de Equipo en Reparación</h1>
            <p class="lead">Ingrese el código de inventario de su equipo para ver el estado actual y el historial de trabajos.</p>
        </header>

        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <form id="formBusquedaReparacion">
                            <div class="input-group">
                                <input type="text" class="form-control form-control-lg" id="codigo_inventario" name="codigo_inventario" placeholder="Código de Inventario (Ej: EQ-1234)" required>
                                <button class="btn btn-primary btn-lg" type="submit" id="btnBuscar">
                                    <i class="bi bi-search"></i> Buscar Estado
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <div id="resultadoBusqueda">
                    <div class="alert alert-info text-center">
                        Ingrese un código para comenzar la búsqueda.
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    $(document).ready(function() {
        $('#formBusquedaReparacion').on('submit', function(e) {
            e.preventDefault();
            
            const codigo = $('#codigo_inventario').val().trim();
            const $resultadoDiv = $('#resultadoBusqueda');
            const $btnBuscar = $('#btnBuscar');

            if (codigo === "") {
                $resultadoDiv.html('<div class="alert alert-warning">Por favor, ingrese un código de inventario.</div>');
                return;
            }

            // Muestra el estado de carga
            $btnBuscar.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Buscando...');
            $resultadoDiv.html('<div class="text-center py-5"><i class="bi bi-gear-wide-connected fa-spin me-2"></i> Cargando información...</div>');
            
            // Envía la solicitud al endpoint que devuelve los detalles
            $.post('reparacion_estado.php', { codigo_inventario: codigo })
                .done(function(data) {
                    $resultadoDiv.html(data);
                })
                .fail(function() {
                    $resultadoDiv.html('<div class="alert alert-danger">Error de comunicación con el servidor. Intente más tarde.</div>');
                })
                .always(function() {
                    $btnBuscar.prop('disabled', false).html('<i class="bi bi-search"></i> Buscar Estado');
                });
        });
    });
    </script>
</body>
</html>