<?php 
require_once '../templates/header.php'; 
// --- Asume que las conexiones $conexion (MySQLi o similar para Equipos) 
// y $pdo (PDO para Tickets) están disponibles aquí o en el header.
// Si no, deben ser inicializadas aquí:

// ** NOTA:** Asegúrate de incluir tu header y conexión a DB aquí.
// require_once 'config/db_connect.php'; 
// require_once 'templates/header.php'; 

// --- 1. LÓGICA DE DATOS PHP ---

// --- 1.1 Tarjetas de Resumen (Counters) ---
// Simulación de consultas (Reemplaza estas con tus consultas reales a la DB)
$abiertos = $conexion->query("SELECT COUNT(id) AS total FROM tickets WHERE estado = 'Abierto'")->fetch_assoc()['total'] ?? 0;
$pendientes = $conexion->query("SELECT COUNT(id) AS total FROM tickets WHERE estado = 'Pendiente'")->fetch_assoc()['total'] ?? 0;
$resueltos = $conexion->query("SELECT COUNT(id) AS total FROM tickets WHERE estado = 'Resuelto'")->fetch_assoc()['total'] ?? 0;
$total_activos = $conexion->query("SELECT COUNT(id) AS total FROM tickets WHERE estado IN ('Abierto', 'Pendiente')")->fetch_assoc()['total'] ?? 0;

// --- 1.2 Datos para Gráfico de Dona (Resumen por Estado) ---
$sql_dona = "SELECT estado, COUNT(id) as cantidad FROM tickets GROUP BY estado";
$resultado_dona = $conexion->query($sql_dona);

$dona_labels = [];
$dona_data = [];
$dona_colors = []; // Definir colores para cada estado

if ($resultado_dona) {
    while ($fila = $resultado_dona->fetch_assoc()) {
        $dona_labels[] = $fila['estado'];
        $dona_data[] = $fila['cantidad'];
        // Asignar colores según el estado (ejemplo, ajusta los tuyos)
        switch ($fila['estado']) {
            case 'Abierto': 
                $dona_colors[] = 'rgba(54, 162, 235, 0.8)'; // Azul
                break;
            case 'Pendiente':
                $dona_colors[] = 'rgba(255, 206, 86, 0.8)'; // Amarillo
                break;
            case 'Resuelto':
                $dona_colors[] = 'rgba(75, 192, 192, 0.8)'; // Verde/Cyan
                break;
            default:
                $dona_colors[] = 'rgba(153, 102, 255, 0.8)'; // Púrpura
        }
    }
}

// --- 1.3 Datos para Gráfico de Barras (Tickets Creados) ---
// *Esta consulta es compleja, requiere agrupar por mes/semana/día. 
// Aquí solo se simulan datos de ejemplo.*
$barra_labels = ['Oct 25', 'Nov 25', 'Dec 25'];
$barra_data_abierto = [1, 2, 3]; // Simulación
$barra_data_proceso = [0, 1, 1]; // Simulación
$barra_data_empleados = [2, 3, 4]; // Simulación (Parece ser un eje secundario o dato extra)

?>

<div class="container-fluid pt-4">

    <h1 class="h2 mb-4">Dashboard General</h1>

    <div class="row mb-4">
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-primary text-white shadow">
                <div class="card-body">
                    <h5 class="card-title fs-2 fw-bold"><?php echo $abiertos; ?></h5>
                    <p class="card-text">Abiertos</p>
                    <i class="bi bi-envelope-open-fill position-absolute end-0 bottom-0 display-4 me-3 mb-2 opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-warning text-dark shadow">
                <div class="card-body">
                    <h5 class="card-title fs-2 fw-bold"><?php echo $pendientes; ?></h5>
                    <p class="card-text">Pendientes</p>
                    <i class="bi bi-clock-history position-absolute end-0 bottom-0 display-4 me-3 mb-2 opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-success text-white shadow">
                <div class="card-body">
                    <h5 class="card-title fs-2 fw-bold"><?php echo $resueltos; ?></h5>
                    <p class="card-text">Resueltos</p>
                    <i class="bi bi-check-circle-fill position-absolute end-0 bottom-0 display-4 me-3 mb-2 opacity-50"></i>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-secondary text-white shadow">
                <div class="card-body">
                    <h5 class="card-title fs-2 fw-bold"><?php echo $total_activos; ?></h5>
                    <p class="card-text">Total Activos</p>
                    <i class="bi bi-list-task position-absolute end-0 bottom-0 display-4 me-3 mb-2 opacity-50"></i>
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-4">
        
        <div class="col-lg-4 mb-4">
            <div class="card h-100 shadow">
                <div class="card-header fw-bold">Resumen por Estado</div>
                <div class="card-body d-flex justify-content-center align-items-center">
                    <?php if (!empty($dona_data)): ?>
                        <canvas id="resumenEstadoChart"></canvas>
                    <?php else: ?>
                        <p class="text-muted">No hay datos para mostrar...</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-8 mb-4">
            <div class="card h-100 shadow">
                <div class="card-header fw-bold">Tickets Creados (Últimos 3 Meses)</div>
                <div class="card-body d-flex justify-content-center align-items-center">
                    <canvas id="ticketsCreadosChart"></canvas>
                </div>
            </div>
        </div>
        
    </div>
    
    <div class="card mb-4 shadow">
        <div class="card-header fw-bold">Filtros y Reportes</div>
        <div class="card-body">
            <form class="row g-3">
                <div class="col-md-4">
                    <label for="buscar" class="form-label">Buscar por Asunto/ID:</label>
                    <input type="text" class="form-control" id="buscar">
                </div>
                <div class="col-md-4">
                    <label for="cliente" class="form-label">Cliente:</label>
                    <select id="cliente" class="form-select"><option>Todos</option></select>
                </div>
                <div class="col-md-4">
                    <label for="agente" class="form-label">Agente:</label>
                    <select id="agente" class="form-select"><option>Todos</option></select>
                </div>

                <div class="col-md-2">
                    <label for="prioridad" class="form-label">Prioridad:</label>
                    <select id="prioridad" class="form-select"><option>Todas</option></select>
                </div>
                <div class="col-md-2">
                    <label for="estado" class="form-label">Estado Ticket:</label>
                    <select id="estado" class="form-select"><option>Todos</option></select>
                </div>
                <div class="col-md-2">
                    <label for="fechaInicio" class="form-label">Fecha Inicio:</label>
                    <input type="date" class="form-control" id="fechaInicio">
                </div>
                <div class="col-md-2">
                    <label for="fechaFin" class="form-label">Fecha Fin:</label>
                    <input type="date" class="form-control" id="fechaFin">
                </div>
                <div class="col-md-2">
                    <label for="estadoFacturacion" class="form-label">Estado Facturación:</label>
                    <select id="estadoFacturacion" class="form-select"><option>Todos</option></select>
                </div>
                
                <div class="col-md-2 align-self-end">
                    <button type="submit" class="btn btn-primary me-2"><i class="bi bi-funnel"></i> Filtrar</button>
                    <button type="button" class="btn btn-secondary"><i class="bi bi-x-circle"></i> Limpiar</button>
                </div>

                <div class="col-12 mt-4 d-flex align-items-center">
                    <p class="me-3 mb-0 text-muted small">La exportación aplicará según filtros de fecha y tablar (requiere el permiso).</p>
                    <button type="button" class="btn btn-success btn-sm me-2"><i class="bi bi-file-earmark-excel"></i> Excel</button>
                    <button type="button" class="btn btn-danger btn-sm me-2"><i class="bi bi-file-earmark-pdf"></i> PDF</button>
                    <button type="button" class="btn btn-info text-white btn-sm"><i class="bi bi-printer"></i> Imprimir</button>
                </div>
            </form>
        </div>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h4">2 Mis Tickets</h2>
        <button class="btn btn-primary"><i class="bi bi-plus-circle-fill"></i> Crear Nuevo Ticket</button>
    </div>
    
    <div class="card shadow">
        <div class="card-body">
            <p class="text-muted">Espacio reservado para el listado/tabla de tickets (Mi Tickets).</p>
        </div>
    </div>


</div> <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">


<script>
document.addEventListener('DOMContentLoaded', function () {
    // --- GRÁFICO 1: RESUMEN POR ESTADO (DOUGHNUT) ---
    const ctxDona = document.getElementById('resumenEstadoChart');
    if (ctxDona) {
        new Chart(ctxDona, {
            type: 'doughnut', 
            data: { 
                labels: <?php echo json_encode($dona_labels); ?>, 
                datasets: [{ 
                    label: 'Cantidad', 
                    data: <?php echo json_encode($dona_data); ?>, 
                    backgroundColor: <?php echo json_encode($dona_colors); ?>, 
                    hoverOffset: 4
                }] 
            },
            options: { 
                responsive: true, 
                maintainAspectRatio: false, 
                plugins: { 
                    legend: { 
                        position: 'right' // La leyenda se ve a la derecha en la imagen
                    } 
                } 
            }
        });
    }

    // --- GRÁFICO 2: TICKETS CREADOS (BARRA) ---
    const ctxBarra = document.getElementById('ticketsCreadosChart');
    if (ctxBarra) {
        new Chart(ctxBarra, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($barra_labels); ?>,
                datasets: [
                    {
                        label: 'Tickets',
                        data: <?php echo json_encode($barra_data_abierto); ?>,
                        backgroundColor: 'rgba(54, 162, 235, 0.7)', // Azul
                        borderWidth: 1
                    },
                    {
                        label: 'En Proceso',
                        data: <?php echo json_encode($barra_data_proceso); ?>,
                        backgroundColor: 'rgba(255, 206, 86, 0.7)', // Amarillo
                        borderWidth: 1
                    },
                    {
                        label: 'Nº de Empleados', // Este dataset parece ser de otra escala, podrías usar un eje Y secundario
                        data: <?php echo json_encode($barra_data_empleados); ?>,
                        backgroundColor: 'rgba(75, 192, 192, 0.7)', // Verde/Cyan
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: { 
                    y: { 
                        beginAtZero: true, 
                        ticks: { precision: 0 } 
                    } 
                },
                plugins: { 
                    legend: { position: 'right' } // Leyenda a la derecha
                }
            }
        });
    }
});
</script>

<?php 
// ** NOTA:** Incluye el footer aquí
// require_once 'templates/footer.php'; 
?>